using System;
using System.Windows.Forms;
using ScriptPortal.Vegas;

public class EntryPoint
{
    Vegas myVegas = null;
    Form dlog = new Form();
    public void FromVegas(Vegas vegas)
    {
        myVegas = vegas;
        dlog.Text = "Ajustar PlaybackRate";
        dlog.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;
        dlog.StartPosition = FormStartPosition.CenterScreen;
        dlog.Width = 246;
        dlog.Height = 74;

        Button Button1;
        Button1 = new Button();
        Button1.Left =  4;
        Button1.Top =  2;
        Button1.Width = 50;
        Button1.Height = 30;
        Button1.Text = "95%";
        Button1.Click += Button1_Click;
        dlog.Controls.Add(Button1);

        Button Button2;
        Button2 = new Button();
        Button2.Left = 58;
        Button2.Top = 2;
        Button2.Width = 50;
        Button2.Height = 30;
        Button2.Text = "100%";
        Button2.Click += Button1_Click;
        dlog.Controls.Add(Button2);

        Button Button3;
        Button3 = new Button();
        Button3.Left = 166;
        Button3.Top = 2;
        Button3.Width = 60;
        Button3.Height = 30;
        Button3.Text = "Cancelar";
        Button3.Click += Button3_Click;
        dlog.Controls.Add(Button3);
        dlog.CancelButton = Button3;

        Button Button4;
        Button4 = new Button();
        Button4.Left = 112;
        Button4.Top = 2;
        Button4.Width = 50;
        Button4.Height = 30;
        Button4.Text = "105%";
        Button4.Click += Button1_Click;
        dlog.Controls.Add(Button4);

        dlog.ShowDialog(vegas.MainWindow);
    }
  void Button1_Click(Object sender, EventArgs args)
    {
        Button b = (Button)sender;
        float p ;
        if (b.Text == "95%")
            p = 0.95f;
        else if (b.Text == "105%")
            p = 1.05f;
        else
            p = 1.00f;
        foreach (Track track in myVegas.Project.Tracks)
        {
            if (track.IsAudio())
                foreach (TrackEvent trackEvent in track.Events)
                {
                    if (trackEvent.Selected)
                    {
                        trackEvent.AdjustPlaybackRate(p,true);
                    }
                }
        }
        dlog.Close();
    }
    void Button3_Click(Object sender, EventArgs args)
    {
        dlog.Close();
        dlog.Dispose();
    }

}